/* 
 *  WrapUPWithCodeRequest.java
 * 
 *  Copyright 2016 Avaya Inc. All Rights Reserved.
 * 
 *  Usage of this source is bound to the terms described
 *  in AvayaLicenseSDK.rtf.
 * 
 *  Avaya - Confidential & Proprietary. Use pursuant to your signed agreement
 *  or Avaya Policy
 * 
 */
package com.avaya.ccs.javafxrefclient.request;

import com.avaya.ccs.javafxrefclient.Logger;
import com.avaya.ccs.api.ContactCenterCodeI;

public class WrapUPWithCodeRequest extends InteractionRequest {

    private static final Logger LOG = Logger.getLogger(WrapUPWithCodeRequest.class);
    private final ContactCenterCodeI code;

    public WrapUPWithCodeRequest(String interactionID, ContactCenterCodeI code) {
        super(LOG, interactionID);
        this.code = code;
    }

    /**
     * The call method executes on the outgoingRequest thread
     *
     * @return
     * @throws Exception
     */
    @Override
    protected Object call() throws Exception {
        String methodName = "call() ";
        LOG.trace(methodName + "+");
        getInteraction().wrapupWithCode(code);
        LOG.trace(methodName + "-");
        return null;
    }
}
